<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once '../config/db.php';

// Función para limpiar nombres (Slug)
function limpiarNombre($string) {
    $string = trim($string);
    $string = str_replace(array('á','à','ä','â','ª','Á','À','Â','Ä'), array('a','a','a','a','a','A','A','A','A'), $string);
    $string = str_replace(array('é','è','ë','ê','É','È','Ê','Ë'), array('e','e','e','e','E','E','E','E'), $string);
    $string = str_replace(array('í','ì','ï','î','Í','Ì','Ï','Î'), array('i','i','i','i','I','I','I','I'), $string);
    $string = str_replace(array('ó','ò','ö','ô','Ó','Ò','Ö','Ô'), array('o','o','o','o','O','O','O','O'), $string);
    $string = str_replace(array('ú','ù','ü','û','Ú','Ù','Û','Ü'), array('u','u','u','u','U','U','U','U'), $string);
    $string = str_replace(array('ñ','Ñ','ç','Ç'), array('n','N','c','C'), $string);
    $string = preg_replace('/[^a-zA-Z0-9-]/', '-', $string);
    $string = strtolower($string);
    return $string;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = $_POST['full_name'];
    $position  = $_POST['position'];
    $whatsapp  = $_POST['whatsapp'];
    $email     = $_POST['email'];

    $photo_url = 'default_avatar.jpg';
    
    if (!empty($_FILES['photo']['name'])) {
        $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
        $slug = limpiarNombre($full_name);
        $new_name = $slug . "." . $ext;
        
        // Crear carpeta si no existe
        if (!is_dir("../public/img/asesores")) { mkdir("../public/img/asesores", 0777, true); }

        // Evitar duplicados
        if (file_exists("../public/img/asesores/" . $new_name)) {
            $new_name = $slug . "-" . time() . "." . $ext;
        }

        if (move_uploaded_file($_FILES['photo']['tmp_name'], "../public/img/asesores/" . $new_name)) {
            $photo_url = $new_name;
        }
    }

    $sql = "INSERT INTO team_members (full_name, position, whatsapp, email, photo_url) VALUES (?, ?, ?, ?, ?)";
    $pdo->prepare($sql)->execute([$full_name, $position, $whatsapp, $email, $photo_url]);
    
    header("Location: asesores.php?status=created");
    exit;
}

require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';
?>

<main class="flex-1 p-8">
    <div class="max-w-3xl mx-auto">
        <div class="flex items-center gap-4 mb-8">
            <a href="asesores.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 text-gray-500 hover:text-brand-red transition-colors shadow-sm">
                <i class="ri-arrow-left-line text-xl"></i>
            </a>
            <h1 class="font-display font-black text-3xl dark:text-white uppercase">Nuevo Asesor</h1>
        </div>

        <form method="POST" enctype="multipart/form-data" class="bg-white dark:bg-brand-dark p-8 rounded-xl border border-gray-100 dark:border-white/5 space-y-6 shadow-xl">
            
            <div class="flex justify-center mb-6">
                <label for="photoInput" class="relative group cursor-pointer">
                    <div class="w-32 h-32 rounded-full overflow-hidden border-4 border-gray-100 dark:border-white/10 shadow-lg bg-gray-50 dark:bg-black/20 flex items-center justify-center">
                        <img id="preview" src="../public/img/default_avatar.jpg" class="w-full h-full object-cover opacity-50">
                        <div class="absolute inset-0 flex flex-col items-center justify-center text-gray-400 group-hover:text-brand-red transition-colors z-10">
                            <i class="ri-camera-add-line text-3xl"></i>
                        </div>
                    </div>
                    <input id="photoInput" type="file" name="photo" class="hidden" accept="image/*" onchange="showPreview(event)">
                </label>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Nombre Completo</label>
                    <input type="text" name="full_name" required placeholder="Ej. Alex Rivera" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Cargo</label>
                    <input type="text" name="position" required placeholder="Ej. Asesor Técnico" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">WhatsApp</label>
                    <input type="text" name="whatsapp" placeholder="987654321" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Email</label>
                    <input type="email" name="email" placeholder="alex@jfd.com" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
            </div>

            <button type="submit" class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-bold uppercase py-4 rounded-xl shadow-lg transition-all transform active:scale-95">
                Registrar Asesor
            </button>
        </form>
    </div>
</main>

<script>
function showPreview(event) {
    const input = event.target;
    const preview = document.getElementById('preview');
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.classList.remove('opacity-50'); // Quitar transparencia al cargar imagen
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>

<?php require_once 'includes/footer.php'; ?>